{**********************************************************************
{*
{* BusyBox uUtils -- Version 3.0  (interface)
{*
{* Copyright (c)
{* Apple Computer, Inc. 1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the interface to the code which implements
{* various utility routines used by the busybox program.
{*
{**********************************************************************}

Unit uUtils;

INTERFACE

USES
    types,
    locator,
    intMath;


CONST
    srcCopy =   $0000;

FUNCTION IntToString (i : Integer): STR255;
FUNCTION LongToString (l : LongInt): STR255; { test }
FUNCTION IsToolError: BOOLEAN;
PROCEDURE INC(VAR anIndex : Integer);
PROCEDURE Dec(VAR anIndex: Integer);

IMPLEMENTATION

{$R-}

FUNCTION IntToString (i : Integer): STR255;
var
    size,
    count   : Integer;
    num : longInt;
    str : string[20];
BEGIN
    num := i;
    size := 0;
    Long2Dec(num, @str, 19, true);
    FOR count := 1 to 19 DO
    BEGIN
    IF (str[count] = '-') OR ((str[count] >= '0') AND (str[count] <= '9')) THEN
    BEGIN
    size := size + 1;
    IntToString[size] := str[count];
    END;
    END;
    IntToString[0] := char(size);
END;

FUNCTION LongToString (l : LongInt): STR255; { test }
var
    size,
    count   : Integer;
    num : longInt;
    str : string[20];
BEGIN
    num := l;
    size := 0;
    Long2Dec(num, @str, 19, true);
    FOR count := 1 to 19 DO
    BEGIN
    IF (str[count] = '-') OR ((str[count] >= '0') AND (str[count] <= '9')) THEN
    BEGIN
    size := size + 1;
    LongToString[size] := str[count];
    END;
    END;
    LongToString[0] := char(size);
END;


FUNCTION IsToolError: BOOLEAN;
BEGIN
    IsToolError := FALSE;
    if ToolErrorNum <> 0 then
    IsToolError := TRUE;
END;

PROCEDURE INC(VAR anIndex : Integer); {increase integer param by 1}
BEGIN
    anIndex := anIndex + 1;
END;

PROCEDURE Dec(VAR anIndex: Integer); {decrease integer param by 1}
BEGIN
    anIndex := anIndex - 1;
END;

END.
